library(dtw)
library(ggplot2)

### Equation: y=a*sin(b*t)+c.unif*amp
# variables
n <- 100 #number of data points
t <- seq(from=0, to=10, length.out=100)
a <- 1
b <- 1
c.unif <- runif(n, min=-1, max=1)
amp <- 0.1


# generate data and calculate "y"
set.seed(1)
y1 <- a*sin(b*t)+c.unif*amp # uniform error

plot(t, y1,  t="l",col=2)

query <- cos(t)

alignment<-dtw(y1,query,keep=TRUE)

# A sample of the plot styles. See individual plotting functions for details

plot(alignment, type="alignment",
     main="DTW")

plot(alignment, type="twoway", 
     main="DTW")

plot(alignment, type="threeway",
     main="The warping curve")

alignment$normalizedDistance
alignment$distance

alignment_1<-dtw(y1,query,keep=TRUE, step.pattern = symmetric1)

plot(alignment_1, type="twoway", 
     main="DTW")

plot(alignment_1, type="threeway",
     main="The warping curve")

alignment_1$normalizedDistance
alignment_1$distance

